import '../../../core/utils/method.dart';
import '../../../core/utils/url_container.dart';
import '../../model/global/response_model/response_model.dart';
import '../../services/api_service.dart';

class InvoiceRepo {
  ApiClient apiClient;
  InvoiceRepo({required this.apiClient});

  Future<ResponseModel> getAllInvoiceData(int page) async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.allInvoiceUrl}?page=$page";
    ResponseModel responseModel = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return responseModel;
  }

  Future<ResponseModel> submitInvoicePayment({
    required String pin,
    required String invoiceID,
    required String otpType,
  }) async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.invoicePayment}/$invoiceID";

    Map<String, String> params = {
      "pin": pin,
      "otp_type": otpType,
    };

    ResponseModel responseModel = await apiClient.request(url, Method.postMethod, params, passHeader: true);

    return responseModel;
  }

    Future<ResponseModel> rejectInvoice(String invoiceId, String cancelReason) async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.invoiceRejectUrl}$invoiceId";
    Map<String, String> params = {
      "reject_reason": cancelReason,
    };
    ResponseModel responseModel = await apiClient.request(url, Method.postMethod, params, passHeader: true);
    return responseModel;
  }
}
